*! version 3.1.9.2 05feb2026 by alexis.dinno@pdx.edu
*! perform two one-sided tests for equivalence of RR and unity in paired data

* Syntax:  tostrrp varname1 == varname2 [if exp] [in range] , delta0(#) [
*          deltaupper(#) alpha(#) relevance treatment1(string) 
*          treatment2(string) outcome(string) nooutcome(string)]

program define tostrrp, rclass byable(recall)

  syntax varlist [if] [in] , delta0(real) [ alpha(real 0.05) /*
  */     deltaupper(real 0) EXactchisq treatment1(string) treatment2(string) /*
  */     OUTcome(string) NOOutcome(string) RELevance]

  if int(_caller())<8 {
    di in r "tostrrp- does not support this version of Stata." _newline
    di as txt "All requests for specific version support are welcome and will be considered."
    exit
  }

  if int(_caller())<14 {
    version 8.0, missing
    }
   else {
    version 14.0, missing
    }

  tokenize `varlist'

* Validate delta0
  if (`delta0' < 0 | `delta0' > 1 ) {
    noisily: di as err "delta0 must be a positive real value that is less than or equal to 1"
    exit 198
    }

* Validate deltaupper
  if (`deltaupper' < 1 & `deltaupper' !=0) {
    noisily: di as err "deltaupper must be a positive real value that is greater than or equal to 1"
    exit 198
    }
   else {
    local upper = 1/`deltaupper'
	}
  if `deltaupper' == 0 {
    local upper = `delta0'
    }
  local lower = `delta0'

* Set up treatment and outcome status names, as user requests
*  local outcome = ""
*  local nooutcome = ""
  if "`treatment1'" == "" {
    local treatment1 : variable label `1'
	}
  if "`treatment2'" == "" {
    local treatment2 : variable label `2'
	}
  if "`outcome'" == "" {
    local labelname : value label `1'
    if ("`labelname'" == "") {
      local labelname : value label `2'
      }
     else {
      mata: st_vlload("`labelname'", values = ., text = "")
      mata: st_local("outcome", text[2])
      }
    }
  if "`nooutcome'" == "" {
    local labelname : value label `1'
    if ("`labelname'" == "") {
      local labelname : value label `2'
      }
     else {
      mata: st_vlload("`labelname'", values = ., text = "")
      mata: st_local("nooutcome", text[1])
      }
    }

  if "`treatment1'"=="" {
    local treatname1 = "Treatment 1"
	}
   else {
    local treatname1 = "`treatment1'"
	}
  if "`treatment2'"=="" {
    local treatname2 = "Treatment 2"
	}
   else {
    local treatname2 = "`treatment2'"
	}
  if "`outcome'" =="" {
    local positive = "Positive"
	}
   else {
    local positive = "`outcome'"
	}
  if "`nooutcome'" =="" {
    local negative = "Negative"
	}
   else {
    local negative = "`nooutcome'"
	} 

*******************************************************************************
* The business starts here                                                    *
*******************************************************************************

  quietly {
    if "`if'" == "" {
      count if `1' == 1 & `2' == 1 `in'
      local a = r(N)
      count if `1' == 0 & `2' == 1 `in'
      local b = r(N)
      count if `1' == 1 & `2' == 0 `in'
      local c = r(N)
      count `in'
      local n = r(N)
      }
	 else {
	  count `if' & `1' == 1 & `2' == 1 `in'
      local a = r(N)
      count `if' & `1' == 0 & `2' == 1 `in'
      local b = r(N)
      count `if' & `1' == 1 & `2' == 0 `in'
      local c = r(N)
      count `if' `in'
      local n = r(N)
      }
    }
  if `upper' == `lower' { 
    tostrrpi `a' `b' `c' `n' `delta0', alpha(`alpha') `exactchisq' `relevance' treatment1("`treatname1'") treatment2("`treatname2'") outcome("`positive'") nooutcome("`nooutcome'")
	}
   else { 
    tostrrpi `a' `b' `c' `n' `delta0', deltaupper(`deltaupper') `exactchisq' alpha(`alpha') `relevance' treatment1("`treatname1'") treatment2("`treatname2'") outcome("`positive'") nooutcome("`nooutcome'")
	}
  return add        /* return the r() values from tostrrpi call */
  end
