{smcl}
{* *! version 3.1.9.2 05feb2026}{...}
{cmd:help tostpr}
{hline}


{title:Title}

{p2colset 5 15 15 2}{...}
{p2col:{cmd:tostpr} {hline 2}}One- and two-sample {it:z} tests for proportion equivalence{p_end}
{p2colreset}{...}


{title:Syntax}

{pstd}
One-sample proportion equivalence {it:z} test

{p 8 14 2}
{cmd:tostpr} {varname} {cmd:==} {it:#} {ifin}
        [{cmd:,} {opt eqvt:ype(type)}
        {opt eqvl:evel(#)}
        {opt upper:eqvlevel(#)}        
        {opt a:lpha(#)}
        {opt rel:evance}]


{pstd}
Two-sample proportion equivalence {it:z} test

{p 8 14 2}
{cmd:tostpr} {varname:1} {cmd:==} {varname:2} {ifin}
        [{cmd:,} {opt eqvt:ype(type)}
        {opt eqvl:evel(#)} {opt y:ates} {opt ha}
        {opt upper:eqvlevel(#)}        
        {opt a:lpha(#)}
        {opt rel:evance}]


{pstd}
Two-group proportion equivalence {it:z} test

{p 8 14 2}
{cmd:tostpr} {varname} {ifin}
        {cmd:,} {opth by:(varlist:groupvar)}
        [{opt eqvt:ype(type)}
        {opt eqvl:evel(#)}
        {opt upper:eqvlevel(#)}        
        {opt y:ates} {opt ha}
        {opt a:lpha(#)}
        {opt rel:evance}]


{phang}
Immediate form of one-sample {it:z} test for proportion equivalence

{p 8 16 2}
{cmd:tostpri} {it:#obs1} {it:#p1} {it:#p2} 
        [{cmd:,} {opt eqvt:ype(type)}
        {opt eqvl:evel(#)}
        {opt upper:eqvlevel(#)}        
        {opt c:ount}
        {opt a:lpha(#)}
        {opt rel:evance}]


{phang}
Immediate form of two-sample {it:z} test for proportion equivalence

{p 8 16 2}{cmd:tostpri} {it:#obs1} {it:#p1} {it:#obs2} {it:#p2} 
        [{cmd:,} {opt eqvt:ype(type)}
        {opt eqvl:evel(#)} 
        {opt upper:eqvlevel(#)}        
        {opt c:ount}
        {opt y:ates} 
        {opt ha} 
        {opt a:lpha(#)} 
        {opt rel:evance}]


{phang}
{cmd:by} is allowed with the non-immediate form of {cmd:tostpri}; see 
{manhelp by D}.


{synoptset 28 tabbed}{...}
{synopthdr:tostpr & tostpri options}
{synoptline}
{syntab:Miscellaneous}
{synopt :{opt eqvt:ype(string)}}specify equivalence threshold with Delta or epsilon{p_end}
{synopt :{opt eqvl:evel(#)}}the level of tolerance defining the equivalence interval{p_end}
{synopt :{opt upper:eqvlevel(#)}}the upper value of an asymmetric equivalence interval{p_end}
{synopt :{opth by:(varlist:groupvar)}}variable defining the two groups{p_end}
{synopt :{opt c:ount}}integers, not proportions are used with {cmd: tostpri}{p_end}
{synopt :{opt ya:tes}}use the Yates continuity correction{p_end}
{synopt :{opt ha}}use the Hauck-Anderson continuity correction{p_end}
{synopt :{opt a:lpha(#)}}set nominal type I level; default is {opt alpha(0.05)}{p_end}
{synopt :{opt x:name}}the name of the first variable used with {cmd:tostpri}{p_end}
{synopt :{opt y:name}}the name of the second variable used with {cmd:tostpri}{p_end}
{synopt :{opt rel:evance}}perform & report combined tests for difference and equivalence{p_end}
{synoptline}
{p2colreset}{...}


{title:Description}

{pstd}
{cmd:tostpr} tests for the equivalence of proportions within a symmetric 
equivalence interval defined by {opt eqvt:ype} and {opt eqvl:evel} using a two 
one-sided {it:z} tests approach ({help tostpr##Hauck1984:Hauck and Anderson, 1984}; 
{help tostpr##Schuirmann1987:Schuirmann, 1987}).  Typically null hypotheses are 
framed from an assumption of a lack of difference between two quantities, and 
reject this assumption only with sufficient evidence.  When performing tests
for equivalence, one frames a null hypothesis with the assumption that two 
quantities are different within an equivalence interval defined by some chosen 
level of tolerance (as specified by {opt eqvl:evel}).{p_end}

{pstd}
With respect to a {it:z} test of proportions, an equivalence null hypothesis takes 
one of the following two forms depending on whether equivalence is defined in 
terms of Delta (equivalence expressed in the same units as prop(x) and prop(y) 
or in terms of epsilon (equivalence expressed in the units of the {it:z} 
distribution):{p_end}

{p 8}
Ho: |prop(x) - prop(y)| >= Delta, {p_end}
{p 8 8}where the equivalence interval ranges from diff-Delta to diff+Delta, and 
where diff is the difference in proportions.  This translates  directly into two 
one-sided null hypotheses: {p_end}

{p 12}
Ho1: Delta - [prop(x) - prop(y)] <= 0; and{p_end}

{p 12}
Ho2: [prop(x) - prop(y)] + Delta <= 0{p_end}

{p 8}
-OR-

{p 8}
Ho: |z| >= epsilon, {p_end}
{p 8 8}where the equivalence interval ranges from -epsilon to epsilon.  This also 
translates directly into two one-sided null hypotheses: {p_end}

{p 12}
Ho1: epsilon - {it:Z} <= 0; and{p_end}

{p 12}
Ho2: {it:Z} + epsilon <= 0{p_end}

{p 8 8}
When an asymmetric equivalence interval is defined using the {opt upper:eqvlevel} option 
the general negativist null hypothesis becomes:{p_end}

{p 8}
Ho: [prop(x) - prop(y)] <= Delta_lower, or [prop(x) - prop(y)] >= Delta_upper,{p_end}
{p 8 8 }
where the equivalence interval ranges from [prop(x) - prop(y)]+Delta_lower to 
[prop(x) - prop(y)]+Delta_upper.  This also translates directly into two 
one-sided null hypotheses:{p_end}

{p 12}
Ho1: Delta_upper - [prop(x) - prop(y)] <= 0; and{p_end}

{p 12}
Ho2: [prop(x) - prop(y)] - Delta_lower <= 0{p_end}

{p 8}
-OR-

{p 8}
Ho: {it:Z} <= epsilon_lower, or {it:Z} >= epsilon_upper, and{p_end}

{p 12}
Ho1: epsilon_upper - {it:Z} <= 0; and{p_end}

{p 12}
Ho2: {it:Z} - epsilon_lower <= 0{p_end}

{pstd}
NOTE: the appropriate level of {opt alpha} is precisely the same as in the 
corresponding two-sided test for proportion difference, so that, for example, if 
one wishes to make a type I error %5 of the time, one simply conducts both of 
the one-sided tests of Ho1 and Ho2 by comparing the resulting {it:p}-value to 0.05 
({help tostpr##Wellek2010:Wellek, 2010}).{p_end}


{title:Options}

{dlgtab:Main}

{phang}
{opth eqvt:ype(string)} defines whether the equivalence interval will be 
defined in terms of Delta or epsilon ({opt delta}, or {opt epsilon}).  These 
options change the way that {opt evql:evel} is interpreted: when {opt delta} is 
specified, the {opt evql:evel} is measured in the units of the proportion of the 
variable being tested, and when {opt epsilon} is specified, the {opt evql:evel} 
is measured in multiples of the standard deviation of the {it:Z} distribution; put 
another way epsilon = Delta/standard error.  The default is {opt delta}.{p_end}

{marker mineqvlevel}{...}
{p 8 8}
Defining tolerance in terms of epsilon means that it is not possible to reject 
any test of mean equivalence Ho if epsilon <= the critical value of {it:z} for a 
given alpha.  Because epsilon = Delta/standard error, we can see that it is not 
possible to reject any Ho if Delta <= the product of the standard error and 
critical value of {it:z} for a given alpha.  {cmd: tostpr} and {cmd: tostpri} now report 
when either of these conditions obtain.{p_end}

{phang}
{opth eqvl:evel(#)} defines the equivalence threshold for the tests depending on 
whether {opt eqvt:ype} is {opt delta} or {opt epsilon} (see above).  Researchers 
are responsible for choosing meaningful values of Delta or epsilon.  The default 
value is 0.1 when {opt delta} is the type, and is 2 when {opt epsilon} is the type.{p_end}

{phang}
{opt upper:eqvlevel(#)} defines the {it: upper} equivalence threshold for the test, 
and transforms the meaning of {opt eqvl:evel} to mean the {it: lower} equivalence 
threshold for the test.  Also, {opt eqvl:evel} is assumed to be a negative value.  
Taken together, these are analogous to Schuirmann's ({help tostt##Schuirmann1987:1987}) 
asymmetric equivalence intervals.  If {opt upper:eqvlevel}==|{opt eqvl:evel}|, then 
{opt upper:eqvlevel} will be ignored.{p_end}

{phang}
{opth by:(varlist:groupvar)} specifies the {it:groupvar} that defines the two
groups that {cmd:tostpr} will use to test the hypothesis that their proportions 
are different.  Specifying {opt by(groupvar)} implies a two sample {it:z} test.  
Do not confuse the {opt by()} option with the {cmd:by} prefix; you can specify 
both.{p_end}

{phang}
{opt c:ount} specifies that integer counts instead of proportions be used in {cmd:tostpri}.  In 
the first syntax, {cmd:tostpri} expects that #obs1 and #p1 are counts -- #p1 < #obs1 
-- and #p2 is a proportion.  In the second syntax, {cmd:tostpri} expects that all 
four numbers are integer counts, that #obs1 > #p1, and that #obs2 > #p2.

{phang}
{opt y:ates} specifies that the test statistics incorporate the Yates continuity 
correction ({help tostpr##Yates1934:Yates 1934}).  This option is included for convenience 
although the Hauck-Anderson correction (see {opt ha}) is preferred ({help tostpr##Tu1997:Tu 1997}).  This
continuity correction is only applied to the two one-sided {it:z} test statistics, 
and not to any of the Wald confidence intervals.

{phang}
{opt ha} specifies that the test statistics incorporate the Hauck-Anderson 
continuity correction ({help tostpr##Hauck1986:Hauck and Anderson 1986}).  This is the preferred 
continuity correction option ({help tostpr##Tu1997:Tu 1997}).  This continuity 
correction is only applied to the two one-sided {it:z} test statistics, and not to 
any of the Wald confidence intervals.

{phang}
{opt a:lpha(#)} specifies the nominal type I error rate.  The default is {opt a:lpha(0.05)}.{p_end}

{phang}
{opt rel:evance} reports results and inference for combined tests for difference 
and equivalence for a specific {opt a:lpha}, {opt eqvt:ype}, and {opt eqvl:evel}.  
See the Remarks section more details on inference from combined tests.


{title:Remarks}

{pstd}
As described by Tryon and Lewis ({help tostpr##Tryon2008:Tryon and Lewis 2008}), when both 
tests for difference and equivalence are taken together, there are four possible 
interpretations:{p_end}

{p 4 8 2}
1.  One may reject the null hypothesis of no difference, but fail to reject the 
null hypothesis of difference, and conclude that there is a {it: relevant difference} 
in proportions at least as large as Delta or epsilon.{p_end}

{p 4 8 2}
2.  One may fail to reject the null hypothesis of no difference, but reject the 
null hypothesis of difference, and conclude that the proportions are {it: equivalent} 
within the equivalence range (i.e.  defined by Delta or epsilon).{p_end}

{p 4 8 2}
3.  One may reject {it:both} the null hypothesis of no difference and the null 
hypothesis of difference, and conclude that the proportions are {it: trivially different}, 
within the equivalence range (i.e.  defined by Delta or epsilon).{p_end}

{p 4 8 2}
4.  One may fail to reject {it:both} the null hypothesis of no difference and the 
null hypothesis of difference, and draw an {it: indeterminate} conclusion, because 
the data are underpowered to detect difference or equivalence.{p_end}


{title:Examples}

    {hline}
{pstd}Some examples correspond to those written in the help file for {help prtest:prtest}:{p_end}

{pstd}Example 1 setup{p_end}
{pstd}{cmd:.  sysuse auto}{p_end}

{pstd}One-sample proportion equivalence test with asymmetric equivalence interval{p_end}
{pstd}{cmd:.  tostpr foreign==.4, eqvt(delta) eqvl(.15) upper(.2)}{p_end}


{pstd}Example 2 setup{p_end}
{pstd}{cmd:.  webuse cure}{p_end}

{pstd}Two-sample proportion-relevance test; equivalence interval is +/- 1 sd{p_end}
{pstd}beyond the critical value of Z for alpha = 0.05{p_end}
{pstd}epsilon = invnormal(.95)+1 = 2.6448536{p_end}
{pstd}{cmd:.  tostpr cure1==cure2, eqvt(epsilon) eqvl(2.6448536) alpha(0.05) rel}{p_end}


{pstd}Example 3 setup{p_end}
{pstd}{cmd:.  use canada} (requires that you {net "get tost, from(https://alexisdinno.com/stata/)":install canada.dta}){p_end}

{pstd}Two-group proportion equivalence test from {help tostpr##Tu1997:Tu 1997, p 276}, and incorporating{p_end}
{pstd}a Hauck and Anderson continuity correction from that same example.{p_end}
{pstd}{cmd:.  tostpr drug, by(group) eqvt(delta) eqvl(.2) ha alpha(0.05)}{p_end}


{pstd}Example 4{p_end}
{pstd}Immediate form of one-sample z test for proportion equivalence{p_end}
{pstd}Note warning about value of Delta!{p_end}
{pstd}{cmd:.  tostpri 50 .52 .70, eqvt(delta) eqvl(.1)}{p_end}


{pstd}Example 5{p_end}
{pstd}First two numbers are counts; equivalence interval is +/- 1 sd{p_end}
{pstd}beyond the critical value of Z for alpha = 0.05{p_end}
{pstd}epsilon = invnormal(.95)+1 = 2.6448536{p_end}
{pstd}{cmd:.  tostpri 30 4  .7, count eqvt(epsilon) eqvl(2.6448536) a(0.05) rel}{p_end}


{pstd}Example 6{p_end}
{pstd}6a Immediate form of two-sample z test for proportion equivalence using an{p_end}
{pstd}example from {help tostpr##Tu1997:Tu 1997, p 276}, and incorporating the Hauck and Anderson{p_end}
{pstd}continuity correction from that same example.{p_end}
{pstd}{cmd:.  tostpri 101 .40594059 100 .49, eqvt(delta) eqvl(.2) ha}{p_end}


{pstd}6b The same example, but all numbers are counts{p_end}
{pstd}{cmd:.  tostpri 101 41 100 49, count eqvt(delta) eqvl(.2) ha}{p_end}
    {hline}


{title:Saved results}

{pstd}
The one-sample forms of {cmd:tostpr} and {cmd:tostpri} saves the following in 
{cmd:r()}:

{synoptset 15 tabbed}{...}
{p2col 5 15 19 2: Scalars}{p_end}
{synopt:{cmd:r(z2)}}{it:z} statistic under Ho2{p_end}
{synopt:{cmd:r(z1)}}{it:z} statistic under Ho1{p_end}
{synopt:{cmd:r(P_1)}}proportion for variable 1{p_end}
{synopt:{cmd:r(N_1)}}number of observations for variable 1{p_end}
{synopt:{cmd:r(Delta)}}Delta, tolerance level defining the equivalence interval; OR{p_end}
{synopt:{cmd:r(Du)}}Delta_upper, tolerance level defining the equivalence interval's upper side; AND{p_end}
{synopt:{cmd:r(Dl)}}Delta_lower, tolerance level defining the equivalence interval's lower side; OR{p_end}
{synopt:{cmd:r(epsilon)}}epsilon, tolerance level defining the equivalence interval{p_end}
{synopt:{cmd:r(eu)}}epsilon_upper, tolerance level defining the equivalence interval's upper side; AND{p_end}
{synopt:{cmd:r(el)}}epsilon_lower, tolerance level defining the equivalence interval's lower side{p_end}
{synopt:{cmd:r(relevance)}}Relevance test conclusion for given alpha and Delta/epsilon{p_end}
{p2colreset}{...}

{pstd}
The two-sample and two-group forms of {cmd:tostpr} and {cmd: tostpri} save the 
following in {cmd:r()}:

{synoptset 15 tabbed}{...}
{p2col 5 15 19 2: Scalars}{p_end}
{synopt:{cmd:r(z2)}}{it:z} statistic under Ho2{p_end}
{synopt:{cmd:r(z1)}}{it:z} statistic under Ho1{p_end}
{synopt:{cmd:r(P_2)}}proportion for variable 2{p_end}
{synopt:{cmd:r(N_2)}}number of observations for variable 2{p_end}
{synopt:{cmd:r(P_1)}}proportion for variable 1{p_end}
{synopt:{cmd:r(N_1)}}number of observations for variable 1{p_end}
{synopt:{cmd:r(Delta)}}Delta, tolerance level defining the equivalence interval; OR{p_end}
{synopt:{cmd:r(Du)}}Delta_upper, tolerance level defining the equivalence interval's upper side; AND{p_end}
{synopt:{cmd:r(Dl)}}Delta_lower, tolerance level defining the equivalence interval's lower side; OR{p_end}
{synopt:{cmd:r(epsilon)}}epsilon, tolerance level defining the equivalence interval{p_end}
{synopt:{cmd:r(eu)}}epsilon_upper, tolerance level defining the equivalence interval's upper side; AND{p_end}
{synopt:{cmd:r(el)}}epsilon_lower, tolerance level defining the equivalence interval's lower side{p_end}
{synopt:{cmd:r(relevance)}}Relevance test conclusion for given alpha and Delta/epsilon{p_end}
{p2colreset}{...}


{title:Author}

{pstd}Alexis Dinno{p_end}
{pstd}Portland State University{p_end}
{pstd}alexis.dinno@pdx.edu{p_end}

{pstd}
Development of {net "describe tost, from(https://alexisdinno.com/stata/)":tost} is 
ongoing, please contact me with any questions, bug reports or suggestions for 
improvement.  Fixing bugs will be facilitated by sending along:{p_end}

{p 8 8 4}(1) a copy of the data (de-labeled or anonymized is fine),{p_end}
{p 8 8 4}(2) a copy of the command used, and{p_end}
{p 8 8 4}(3) a copy of the exact output of the command.{p_end}

{pstd}
I am endebted to my winter 2013 students for their inspiration.


{title:Suggested citation}

{p 4 8}
Dinno, A.  2025.  {bf:tostpr}: One- and two-sample {it:z} tests for 
proportion equivalence.  In {bf:tost} Stata software package.  URL: {view "https://www.alexisdinno.com/stata/tost.html"}{p_end}


{title:References}

{marker Hauck1984}{...}
{phang}
Hauck, W. W., and Anderson, S.  1984.  {browse "https://pubmed.ncbi.nlm.nih.gov/6747820/":A new statistical procedure for testing equivalence in two-group comparative bioavailability trials}.  
{it:Journal of Pharmacokinetics and Pharmacodynamics}.  12: 83-91

{marker Hauck1986}{...}
{phang}
Hauck, W. W., and Anderson, S.  1986.  {browse "https://www.jstor.org/stable/2684618":A comparison of large-sample confidence interval methods for the difference of two binomial probabilities}.  {it: The American Statistician}, 40: 318-322

{marker Schuirmann1987}{...}
{phang}
Schuirmann, D. A.  1987.  {browse "https://pubmed.ncbi.nlm.nih.gov/3450848/":A comparison of the two one-sided tests procedure and the power approach for assessing the equivalence of average bioavailability}.  
{it:Journal of Pharmacokinetics and Biopharmaceutics}.  15: 657-680

{marker Tryon2008}{...}
{phang}
Tryon, W. W., and Lewis, C.  2008.  
{browse "https://pubmed.ncbi.nlm.nih.gov/18778155/":An inferential confidence interval method of establishing statistical equivalence that corrects Tryon's (2001) reduction factor}.  {it:Psychological Methods}.  13: 272-277

{marker Tu1997}{...}
{phang}
Tu, D.  1997.  {browse "https://www.tandfonline.com/doi/abs/10.1080/00949659708811860":Two one-sided tests procedures in establishing therapeutic equivalence with binary clinical endpoints: Fixed sample performances and sample size determination}.  {it: Journal of Statistical Computing and Simmulation}.  59: 271-290

{marker Yates1934}{...}
{phang}
Yates, F.  1934.  {browse "https://www.jstor.org/stable/2983604":Contingency tables involving small numbers and the chi-squared test}.  {it: Supplement to the Journal of the Royal Statistical Society}.  1: 217-235

{marker Wellek2010}{...}
{phang}
Wellek, S.  2010.  {browse "https://www.routledge.com/Testing-Statistical-Hypotheses-of-Equivalence-and-Noninferiority/Wellek/p/book/9781439808184":{it:Testing Statistical Hypotheses of Equivalence and Noninferiority}}, 
second edition.  Chapman and Hall/CRC Press.  p.  31{p_end}


{title:Also See}

{psee}
{space 2}Help: {help tost:tost}, {help pkequiv:pkequiv}, {help prtest:prtest}{p_end}

